#!/usr/bin/perl
#-----------------------------------------------------------------------------
# Detail AWStats plugin
# This plugin stores additional information in a sqlite database, for showing
# guest click-through and other detailed information
#-----------------------------------------------------------------------------
# Perl Required Modules: DBI, DBD::SQLite, Date::Manip
#-----------------------------------------------------------------------------
# $Revision: 1.2 $ - $Author: calin $ - $Date: 2008/07/14 22:23:27 $


# <-----
# ENTER HERE THE USE COMMAND FOR ALL REQUIRED PERL MODULES
# ----->
use strict;no strict "refs";
use Date::Manip;
use DBI;
my @drivers = DBI->available_drivers;
if(! grep("SQLite", @drivers))
{
  return "Error: Need DBD::SQLite perl module";
}

#-----------------------------------------------------------------------------
# PLUGIN VARIABLES
#-----------------------------------------------------------------------------
# <-----
# ENTER HERE THE MINIMUM AWSTATS VERSION REQUIRED BY YOUR PLUGIN
# AND THE NAME OF ALL FUNCTIONS THE PLUGIN MANAGE.
my $PluginNeedAWStatsVersion="6.7";
my $PluginHooksFunctions="ShowInfoHost BuildFullHTMLOutput";
my $PluginName="detail";
# ----->

# <-----
# IF YOUR PLUGIN NEED GLOBAL VARIABLES, THEY MUST BE DECLARED HERE.
use vars qw/
$dbh
$drawdie
/;
# ----->


#-----------------------------------------------------------------------------
# PLUGIN FUNCTION: Init_pluginname
#-----------------------------------------------------------------------------
sub Init_detail {
	my $InitParams=shift;
	my $checkversion=&Check_Plugin_Version($PluginNeedAWStatsVersion);

	# <-----
	# ENTER HERE CODE TO DO INIT PLUGIN ACTIONS
	debug(" Plugin detail: InitParams=$InitParams",1);
   	my ($db) = split(/\s+/,$InitParams,1);
   	if (! $db) { $db="$DirData/detail.sqlite"; }
	$dbh = DBI->connect("dbi:SQLite:dbname=$db","","");
	my @tables = $dbh->tables();
	if(! grep($_ eq '"log"', @tables))
	{
	  $dbh->do("create table log (
  		ip varchar(20),
		user text,
		time integer,
		method text,
		url text,
		status integer,
		bytes integer,
		referer text,
		agent text,
		browser text,
		os text
		);");
	  #"%host %other %logname %time1 %methodurl %code %bytesd %refererquot %uaquot"
	}
	debug(" Plugin $PluginName: Initialized with database $db",1);

	return ($checkversion?$checkversion:"$PluginHooksFunctions");
}


#-----------------------------------------------------------------------------
# PLUGIN FUNCTION: ShowInfoHost_pluginname
# UNIQUE: NO (Several plugins using this function can be loaded)
# Function called to add additionnal columns to the Hosts report.
# This function is called when building rows of the report (One call for each
# row). So it allows you to add a column in report, for example with code :
#   print "<TD>This is a new cell for $param</TD>";
# Parameters: Host name or ip
#-----------------------------------------------------------------------------
sub ShowInfoHost_detail
{
  my $param="$_[0]";
  if ($param eq '__title__')
  {
    print
    "<th width=\"50\">".
    "Detail".
    "</th>";
  }
  else
  {
    print "<td>";
    if($param)
    {
      print "<a href=\"".XMLEncode("$AWScript?pluginmode=detail&config=$SiteConfig&")."page=host&host=$param&month=$MonthRequired&year=$YearRequired\">&gt;</a>";
    }
    print "</td>";
  }
}

#-----------------------------------------------------------------------------
# PLUGIN FUNTION: BuildFullHTMLOutput_pluginname
# UNIQUE: NO (Several plugins using this function can be loaded)
# Function called to output an HTML page completely built by plugin instead
# of AWStats output
#-----------------------------------------------------------------------------
sub BuildFullHTMLOutput_detail
{
# <-----
  # Why do I need to do this?
  %MonthNumLib = ("01","$Message[60]","02","$Message[61]","03","$Message[62]","04","$Message[63]","05","$Message[64]","06","$Message[65]","07","$Message[66]","08","$Message[67]","09","$Message[68]","10","$Message[69]","11","$Message[70]","12","$Message[71]");

  # Header stuff
  print
  "<style>\n".
  "  table {\n".
  "    width: 100%;\n".
  "  }\n".
  "  td {\n".
  "    text-align: left;\n".
  "  }\n".
  "  td[align=right] {\n".
  "    text-align: right;\n".
  "  }\n".
  "  .collapsed .pages{\n".
  "    display: none;\n".
  "  }\n".
  "  .expanded {\n".
  "    display: static;\n".
  "  }\n".
  "  .header {\n".
  "    background-color: rgb(220,220,255);\n".
  "  }\n".
  "</style>\n".
  "<script type='text/javascript'>\n".
  "  function iesucks()\n".
  "  {\n".
  "    var tds = document.getElementsByTagName('td');\n".
  "    for(var t in tds)\n".
  "    {\n".
  "      if(String(tds[t].onclick).match(/expandcollapse/)) expandcollapse(tds[t]);\n".
  "    }\n".
  "  }\n".
  "  function expandcollapse(obj)\n".
  "  {\n".
  "    if(obj.innerHTML == '-')\n".
  "    {\n".
  "      obj.innerHTML = '+';\n".
  "      obj.parentNode.parentNode.parentNode.className = 'collapsible collapsed';\n".
  "    }\n".
  "    else\n".
  "    {\n".
  "      obj.innerHTML = '-';\n".
  "      obj.parentNode.parentNode.parentNode.className = 'collapsible expanded';\n".
  "    }\n".
  "  }\n".
  "</script>\n";

  my $page='';
  if ($QueryString =~ /page=([^&]+)/i)
  { $page=&DecodeEncodedString("$1"); }

  my ($start, $end);
  if($MonthRequired ne "all") 
  {
    $start = UnixDate("$MonthRequired/01/$YearRequired", "%s");
    $end = UnixDate(($MonthRequired+1)."/01/$YearRequired", "%s");
  }
  else
  {
    $start = UnixDate("01/01/$YearRequired", "%s");
    $end = UnixDate("01/01/".($YearRequired+1), "%s");
  }

  if($page eq "host")
  {
    my $host='';
    if ($QueryString =~ /host=([^&]+)/i)
    { $host=&DecodeEncodedString("$1"); }
    print "<h3>Click Stream for $page $host";
    my $ip;
    if($host !~ /^([0-9]{1,3}\.){3}[0-9]{1,3}$/)
    {
      while(my ($key, $val) = each %TmpDNSLookup)
      {
        if($val eq $host)
        {
          $ip = $key;
          last;
        }
      }
    }
    else { $ip = $host; }
    if(!$ip) { $ip = join(".", unpack("C4", gethostbyname($host))); }
    if(!$ip && $host =~ /([0-9]{1,3}[-_\.][0-9]{1,3}[-_\.][0-9]{1,3}[-_\.][0-9]{1,3})/)
    {
      $ip = $1;
      $ip =~ s/[^0-9]/./g;
    }
    if($ip ne $host){ print "($ip)"; }
    print "</h3>\n";
    $host = $ip;

    my $sth = $dbh->prepare(
    	"select * from log where ip = ? ".
    	"and time >= ? and time < ? ".
	"order by time;");
    $sth->execute($host, $start, $end);
  
    my %mapping;
    my %att;
    $att{'root'} = 1;
    my @chld;
    my %sessions;
    $sessions{"attributes"} = \%att;
    $sessions{"children"} = \@chld;
    while ( my $row = $sth->fetchrow_hashref )
    {
      if(!$sessions{'attributes'}{'FirstTime'}) { $sessions{"attributes"}{"FirstTime"} = $$row{'time'}; }
      $sessions{"attributes"}{"LastTime"} = $$row{'time'};
      my $ref = $$row{'referer'};
      my $site = $SiteDomain;
      $site =~ s/^www\.//;
      $ref =~ s/^https?:\/\/(www\.)?$site//g;
      my @children;
      my %obj;
      $obj{"attributes"} = $row;
      $obj{"children"} = \@children;
      if($mapping{$ref})
      {
        push @{$mapping{$ref}{'children'}}, \%obj;
	$mapping{$$row{'url'}} = \%obj;
      }
      else
      {
        $$row{'entry'} = $$row{'referer'};
        if($$row{'entry'} eq "-"){ $$row{'entry'} = $Message[38]; }
        push @{$sessions{'children'}}, \%obj;
	$mapping{$$row{'url'}} = \%obj;
      }
    }

    print &drawsession(\%sessions);
    print "<script>iesucks();</script>\n";
  }
  print "Generated by the detail plugin, written by John Hanely";
  return 1;
# ----->
}

sub drawsession
{ # Expects an xml-style hash, with a hash of attributes and an array of children.
  my $obj = shift;
  my $att = $$obj{'attributes'};
  my $children = $$obj{'children'};
  my $sub = "";
  $$att{'totalsize'} = $$att{'bytes'};
  $$att{'endtime'} = $$att{'time'};
  $$att{'hits'} = 1;
  $$att{'pages'} = 0;
  my @oslist;
  push @oslist, $$att{'os'};
  $$att{'oslist'} = \@oslist;
  my @browserlist;
  push @browserlist, $$att{'browser'};
  $$att{'browserlist'} = \@browserlist;
  grep
  {
    if($$att{'root'}){ $$_{'attributes'}{'top'} = 1; }
    $sub .=
    &drawsession($_);
    $$att{'totalsize'} += $$_{'attributes'}{'totalsize'};
    $$att{'endtime'} = $$_{'attributes'}{'endtime'};
    $$att{'hits'} += $$_{'attributes'}{'hits'};
    $$att{'pages'} += $$_{'attributes'}{'pages'};
    push @oslist, @{$$_{'attributes'}{'oslist'}};
    push @browserlist, @{$$_{'attributes'}{'browserlist'}};
  } @$children;
  my $ret = "";
  if($$att{'root'})
  {
    $$att{'FirstTime'} = UnixDate("epoch $$att{'FirstTime'}", "%q");
    $$att{"LastTime"} = UnixDate("epoch $$att{'LastTime'}", "%q");
    @oslist = sort {uc($b) cmp uc($a)} @oslist;
    my $prev = "Nope.";
    @oslist = grep($_ && $_ ne $prev && ($prev = $_, 1), @oslist);
    @browserlist = sort {uc($b) cmp uc($a)} @browserlist;
    $prev = "Nope.";
    @browserlist = grep($_ && $_ ne $prev && ($prev = $_, 1), @browserlist);
    ##  Ganked shamelessly from awstats.pl
			my $title="$Message[128]";
			&tab_head("$title",0,0,'month');

			my $colspan=3;
			my $w='20';
			if ($LogType eq 'W' || $LogType eq 'S') { $w='17'; $colspan=6; }

			# Show first/last
			$ret .=
			"<tr bgcolor=\"#$color_TableBGRowTitle\">".
			"<td class=\"aws\"><b>$Message[133]</b></td><td class=\"aws\" colspan=\"".($colspan-1)."\">\n".
			($MonthRequired eq 'all'?"$Message[6] $YearRequired":"$Message[5] ".$MonthNumLib{$MonthRequired}." $YearRequired").
			"</td></tr>\n".
			"<tr bgcolor=\"#$color_TableBGRowTitle\">".
			"<td class=\"aws\"><b>$Message[8]</b></td>\n".
			"<td class=\"aws\" colspan=\"".($colspan-1)."\">".($$att{"FirstTime"}?Format_Date($$att{"FirstTime"},0):"NA")."</td>".
			"</tr>\n".
			"<tr bgcolor=\"#$color_TableBGRowTitle\">".
			"<td class=\"aws\"><b>$Message[9]</b></td>\n".
			"<td class=\"aws\" colspan=\"".($colspan-1)."\">".($$att{"LastTime"}?Format_Date($$att{"LastTime"},0):"NA")."</td>\n".
			"</tr>\n".
			"<tr bgcolor=\"#$color_TableBGRowTitle\">".
			"<td class=\"aws\"><b>$Message[21]</b></td>\n".
			"<td class=\"aws\" colspan=\"".($colspan-1)."\">";
			grep
			{
			  my $name = $_;
			  $name =~ s/[0-9].*$//;
    			  my $nameicon=$BrowsersHashIcon{$name}||"notavailable";
    			  my $libbrowser=$BrowsersHashIDLib{$name}||$name;
			  $ret .=
			  "<div><img src=\"$DirIcons\/browser\/$nameicon.png\"".AltTitle("$_")." /> ".
			  $libbrowser.
			  "</div>\n";
			} @browserlist;
			$ret .= "</td>\n".
			"</tr>\n".
			"<tr bgcolor=\"#$color_TableBGRowTitle\">".
			"<td class=\"aws\"><b>$Message[59]</b></td>\n".
			"<td class=\"aws\" colspan=\"".($colspan-1)."\">";
			grep
			{
			  $ret .=
			  "<div><img src=\"$DirIcons\/os\/".lc($_).".png\"".AltTitle("$_")." /> ".
			  $OSHashLib{$_}.
			  "</div>\n";
			} @oslist;
			$ret .= "</td>\n".
			"</tr>\n";

			# Show main indicators title row
			$ret .= "<tr>";
			if ($ShowSummary =~ /V/i) { $ret .= "<td width=\"$w%\" bgcolor=\"#$color_v\"".Tooltip(1).">$Message[10]</td>"; } else { $ret .= "<td bgcolor=\"#$color_TableBGTitle\" width=\"20%\">&nbsp;</td>"; }
			if ($ShowSummary =~ /P/i) { $ret .= "<td width=\"$w%\" bgcolor=\"#$color_p\"".Tooltip(3).">$Message[56]</td>"; } else { $ret .= "<td bgcolor=\"#$color_TableBGTitle\" width=\"20%\">&nbsp;</td>"; }
			if ($ShowSummary =~ /H/i) { $ret .= "<td width=\"$w%\" bgcolor=\"#$color_h\"".Tooltip(4).">$Message[57]</td>"; } else { $ret .= "<td bgcolor=\"#$color_TableBGTitle\" width=\"20%\">&nbsp;</td>"; }
			if ($ShowSummary =~ /B/i) { $ret .= "<td width=\"$w%\" bgcolor=\"#$color_k\"".Tooltip(5).">$Message[75]</td>"; } else { $ret .= "<td bgcolor=\"#$color_TableBGTitle\" width=\"20%\">&nbsp;</td>"; }
			$ret .= "</tr>\n";
			# Show main indicators values for viewed traffic
			$ret .= "<tr>";
			if ($LogType eq 'M') { 
				$ret .=
				"<td class=\"aws\">$Message[165]</td>".
				"<td>&nbsp;<br />&nbsp;</td>\n".
				"<td>&nbsp;<br />&nbsp;</td>\n";
				if ($ShowSummary =~ /H/i) { $ret .= "<td><b>$$att{'hits'}</b></td>"; } else { $ret .= "<td>&nbsp;</td>"; }
				if ($ShowSummary =~ /B/i) { $ret .= "<td><b>".Format_Bytes(int($$att{'totalsize'}))."</b></td>"; } else { $ret .= "<td>&nbsp;</td>"; }
			}
			else {
				if ($ShowSummary =~ /V/i) { $ret .= "<td><b>".@$children."</b></td>"; } else { $ret .= "<td>&nbsp;</td>"; }
				if ($ShowSummary =~ /P/i) { $ret .= "<td><b>$$att{'pages'}</b></td>"; } else { $ret .= "<td>&nbsp;</td>"; }
				if ($ShowSummary =~ /H/i) { $ret .= "<td><b>$$att{'hits'}</b></td>"; } else { $ret .= "<td>&nbsp;</td>"; }
				if ($ShowSummary =~ /B/i) { $ret .= "<td><b>".Format_Bytes(int($$att{'totalsize'}))."</b></td>"; } else { $ret .= "<td>&nbsp;</td>"; }
			}
    ##  End of ganked
    $ret .=
    "  </table>\n".
    "</table>\n".
    "<table>\n".
    $sub.
    "</table>\n";
    return $ret;
  }
  my $ttime = $$att{'endtime'} - $$att{'time'};
  my @times = qw/seconds minutes hours/;
  $$att{'totaltime'} = "";
  while($ttime && @times)
  {
    $$att{'totaltime'} = sprintf("%d ", $ttime%60).(shift @times)." ".$$att{'totaltime'};
    $ttime = sprintf("%d", $ttime/60);
  }
  if($ttime){ $$att{'totaltime'} .= " $ttime"; }
  if(!$$att{'totaltime'}){$$att{'totaltime'} = '1 second';}
  $$att{'totaltime'} =~ s/ /&nbsp;/g;
  $$att{'entry'} =~ s/ /&nbsp;/g;
  if($sub || $$att{'top'})
  {
    $$att{'pages'} += 1;
    $ret .=
    "<tr><td colspan='3'>\n".
    " <table class='collapsible expanded'>\n".
    "  <tr>\n".
    "    <td onclick='expandcollapse(this)' width='1'>-</td>\n".
    "    <td>\n".
    "      <table class='header'>\n".
    "        <tr>\n".
    "          <td>";
    if($$att{'url'} =~ /([^\/]*\/?)$/) { $ret .= $1; }
    $ret .= "</td>\n";
    if($$att{'entry'})
    {
      $ret .= "          <td align='right'>From&nbsp;$$att{'entry'}</td>\n";
    }
    my $brname = $$att{'browser'};
    $brname =~ s/[0-9].*$//;
    my $nameicon=$BrowsersHashIcon{$brname}||"notavailable";
    $ret .=
    "          <td align='right' width='60'>&nbsp;$$att{'pages'} pages</td>\n".
    "          <td align='right' width='50'>&nbsp;$$att{'hits'} hits</td>\n".
    "          <td align='right' width='80'>&nbsp;$$att{'totaltime'}</td>\n".
    "          <td align='right' width='100'>&nbsp;".Format_Bytes($$att{'totalsize'})."&nbsp;Total</td>\n".
    "          <td width='16'><img src=\"$DirIcons\/os\/".lc($$att{'os'}).".png\"";
    if($$att{'os'} =~ /unknown/i)
    {
      $ret .= AltTitle($$att{'agent'});
    }
    else
    {
      $ret .= AltTitle($$att{'os'});
    }
    $ret .= " /></td>\n".
    "          <td width='16'><img src=\"$DirIcons\/browser\/$nameicon.png\"".AltTitle($$att{'browser'})." /></td>\n".
    "        </tr>\n".
    "      </table>\n".
    "    </td>\n".
    "  </tr>\n".
    "  <tr><td></td>\n".
    "    <td class='pages'>\n".
    "      <table>\n";
  }
  $ret .=
  "  <tr>\n".
  "    <td>$$att{'url'}</td>\n".
  "    <td width='1'>";
  my $d = Format_Date(UnixDate("epoch $$att{'time'}", "%q"));
  $d =~ s/ /&nbsp;/g;
  $ret .= "$d</td>\n".
  "    <td align='right' width='130'>".Format_Bytes($$att{'bytes'})."</td>\n".
  "  </tr>\n";
  if($sub || $$att{'top'})
  {
    $ret .= $sub.
    "      </table>\n".
    "    </td>\n".
    "  </tr>\n".
    " </table>\n".
    "</td></tr>\n";
  }
  return $ret;
}

sub analyze_agent
{
  my $UserAgent = lc(shift);
  my $timerecord = 0;
  # Shamelessly ganked from awstats.pl
	# Define precompiled regex
	my $regfavico=qr/\/favicon\.ico$/i;
	my $regrobot=qr/^\/robots\.txt$/i;
	my $regtruncanchor=qr/#(\w*)$/;
	my $regext=qr/\.(\w{1,6})$/;
	my $regipv4=qr/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;
	my $regipv6=qr/^[0-9A-F]*:/i;
	my $regvermsie=qr/msie([+_ ]|)([\d\.]*)/i;
	my $regvernetscape=qr/netscape.?\/([\d\.]*)/i;
	my $regverfirefox=qr/firefox\/([\d\.]*)/i;
	my $regversvn=qr/svn\/([\d\.]*)/i;
	my $regvermozilla=qr/mozilla(\/|)([\d\.]*)/i;
	my $regnotie=qr/webtv|omniweb|opera/i;
	my $regnotnetscape=qr/gecko|compatible|opera|galeon|safari/i;
	my $regreferer=qr/^(\w+):\/\/([^\/:]+)(:\d+|)/;
	my $regget=qr/get|out/i;
	my $regsent=qr/sent|put|in/i;

					# Analyze: Browser
					#-----------------
					my $uabrowser=$TmpBrowser{$UserAgent};
					if (! $uabrowser) {
						my $found=1;
						# IE ?
						if ($UserAgent =~ /$regvermsie/o && $UserAgent !~ /$regnotie/o) {
							$TmpBrowser{$UserAgent}="msie$2";
						}
						# Firefox ?
						elsif ($UserAgent =~ /$regverfirefox/o) {
							$TmpBrowser{$UserAgent}="firefox$1";
						}
						# Subversion ?
						elsif ($UserAgent =~ /$regversvn/o) {
							$TmpBrowser{$UserAgent}="svn$1";
						}
						# Netscape 6.x, 7.x ... ?
						elsif ($UserAgent =~ /$regvernetscape/o) {
							$TmpBrowser{$UserAgent}="netscape$1";
						}
						# Netscape 3.x, 4.x ... ?
						elsif ($UserAgent =~ /$regvermozilla/o && $UserAgent !~ /$regnotnetscape/o) {
							$TmpBrowser{$UserAgent}="netscape$2";
						}
						# Other known browsers ?
						else {
							$found=0;
							foreach (@BrowsersSearchIDOrder) {	# Search ID in order of BrowsersSearchIDOrder
								if ($UserAgent =~ /$_/) {
									my $browser=&UnCompileRegex($_);
									# TODO If browser is in a family, use version
									$TmpBrowser{$UserAgent}="$browser";
									$found=1;
									last;
								}
							}
						}
						# Unknown browser ?
						if (!$found) {
							$TmpBrowser{$UserAgent}='Unknown';
							my $newua=$UserAgent; $newua =~ tr/\+ /__/;
						}
					}
					else {
						if ($uabrowser eq 'Unknown') {
							my $newua=$UserAgent; $newua =~ tr/\+ /__/;
						}
					}
	
					# Analyze: OS
					#------------
					my $uaos=$TmpOS{$UserAgent};
					if (! $uaos) {
						my $found=0;
						# in OSHashID list ?
						foreach (@OSSearchIDOrder) {	# Search ID in order of OSSearchIDOrder
							if ($UserAgent =~ /$_/) {
								my $tmp = &UnCompileRegex($_);
								my $osid=$OSHashID{( $tmp ? $tmp : $_ )};
								$TmpOS{$UserAgent}="$osid";
								$found=1;
								last;
							}
						}
						# Unknown OS ?
						if (!$found) {
							$TmpOS{$UserAgent}='Unknown';
							my $newua=$UserAgent; $newua =~ tr/\+ /__/;
#							$_unknownreferer_l{$newua}=$timerecord;
						}
					}
					else {
						if ($uaos eq 'Unknown') {
							my $newua=$UserAgent; $newua =~ tr/\+ /__/;
#							$_unknownreferer_l{$newua}=$timerecord;
						}
					}
	
  return ($TmpBrowser{$UserAgent}, $TmpOS{$UserAgent});
}

1;	# Do not remove this line
